




/**********************************************************************************************
 *                                                                                            *
 * Ex4.      :   Read Status Detect  at Connecter OUT of Module                               *
 *                                                                                            *
 *              -Befor Run program Save Distance Detect at 10 cm on Module                    *
 *              -Status Detect=0 when Current Distance < Detect Distance(10cm)                * 
 *                                                                                            *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU        : PIC18F8722 (ET-BASE PIC8722(ICD2))                                     *
 *                   : X-TAL : 10 MHz                                                         *
 *                   : CPU Clock = 40 MHz (x4)                                                *  
 *                                                                                            *
 * Editor-Compiler   : CCS Version 4.124                                                      *
 *                                                                                            *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                   *
 * Last Update       : 10/October/2014                                                        *
 *                                                                                            *
 * Port Interface    :  -- MCU-PIC-18F8722--           ---- ET-REMOTE DISTANCE ----           *
 *                                                                                            *
 *                      RB0..RB7(Output)          Connect     LED Common Anode                *
 *                      RD0(Input)(Read Status)   Connect     P1 Connector OUT                *
 *                                                            Disable Filter                  *
 *                                                        5V                                  *
 *                                                       -+-                                  *
 *                                         \\             |                                   *
 *             (Active'0') RB0------------|<|-------------+                                   *
 *                                    .                   |                                   *
 *                                    .                   |                                   *
 *                                    .    \\             |                                   *
 *                         RB7------------|<|-------------+                                   *
 *                                                                                            * 
 *                                                                                            * 
 * Operation  : Read Status Detector by Set Distance for Detect at 10 cm.                     *
 *              When Current Distance less 10 cm LED Port-RB ON if more 10 cm LED Port-RB OFF *  
 *                                                                                            *
 **********************************************************************************************/
 

#include <18F8722.h>
#include <stdio.h>


#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN          //Setup MCU
#use delay (clock = 40000000)                     //delay Clock = (ms)

#use fast_io(ALL)                                 //Stop Set direction Auto for All Port  by Compiler  




/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/

 void main (void) 
  {

    delay_ms(200)              ;       //Wait Module ET-Remote Distance Ready when Power On
       
    set_tris_B(0x00)           ;       //Set RB(0..7) = Output for LED Display  
    set_tris_D(0x01)           ;       //Set RD(0) = input for Read Status Detect 

    OUTPUT_B(0xFF)             ;       //Set data 0xFF Default RB = LED OFF  
    
//----------------- Start Read Status Detecter --------------//

   
    while(true) 
    {   
      if(INPUT(PIN_D0))        //Read Status Detect RD0 if Current Distance > 10 Cm(Logic1) 
        OUTPUT_B(0xFF)       ; //LED PORTB OFF
      else                     //if Current Distance < 10 Cm
        OUTPUT_B(0x00)       ; //LED PORTB ON
    }
  }



